name := "petrus-gteval"


val gitCommitString = SettingKey[String]("gitCommit")
gitCommitString := git.gitHeadCommit.value.getOrElse("Not Set")

buildInfoKeys := Seq[BuildInfoKey](name, gitCommitString)
buildInfoPackage := "petrus.gteval"

val gurobiHome = sys.env("GUROBI_HOME")

unmanagedJars in Compile += file(gurobiHome + "/lib/gurobi.jar")

libraryDependencies += "org.rogach" %% "scallop" % "3.1.0"
libraryDependencies += "org.codehaus.groovy" % "groovy-all" % "2.4.0" 
libraryDependencies += "ch.qos.logback" % "logback-classic" % "1.1.2"
libraryDependencies += "com.github.pathikrit" %% "better-files" % "3.4.0"

