


aggregate.results <- function(input.file, output.file) {
    data <- read.csv(input.file, header=TRUE)
    sta <- list(mean=mean, sd=sd)

    res <- do.call(data.frame, Map(function(sf) do.call(cbind, Map(sf,data)), sta))
    write.csv(round(res,2), output.name, row.names=FALSE)
}


input.name <- commandArgs(trailing=TRUE)[1]
output.name <- commandArgs(trailing=TRUE)[2]

aggregate.results(input.name, output.name)
