
add.score <- function(results.file) {
    results <- read.csv(results.file, header=TRUE)
    results$score = round((results$uctDefenderPayoff.mean - results$randomDefenderPayoff.mean)/(results$gtoptDefenderPayoff.mean - results$randomDefenderPayoff.mean),2)
    if("uctDefenderPayoff.max" %in% names(results)) {
        results$score.max = round((results$uctDefenderPayoff.max - results$randomDefenderPayoff.mean)/(results$gtoptDefenderPayoff.mean - results$randomDefenderPayoff.mean),2)
    }
    
    results <- rbind(results, round(do.call(data.frame, Map(function(col) mean(col, na.rm=TRUE), results)),2))
    
    write.csv(results, results.file, row.names=FALSE)
}


args <- commandArgs(trailingOnly = TRUE)

add.score(args[1])
