# Programs for UCT in Security Games

## In the main folder
Utility scripts for result processing and running test with Scip and Gurobi solver

## Subfolders

### attacker_configs
Not used in the current version

### configs

Configuration files for UCT and Mixed-UCT

### games

Game files

### haskell

Tools written in Haskell (at this moment only one tool, which generates the visualization for buildings generated by buildinlike-rgg)

### run-visualize

Scripts for plotting the learning process

### schedule

Scripts for starting multiple (potentially parallel) learning processes. 

## Project in Java / Scala

The main part is written in Java / Scala. In the master branch it is a maven project, in the development branch it was ported to sbt.

Building the project:

In order to build the project, the Gurobi solver must be installed (at least version 7.5.2). Moreover the environmental variable ```GUROBI_HOME``` has to be set to the install location of the solver and the variable ```LD_LIBRARY_PATH``` has to be extended with the location of the Gurobi library files (should be most often ```$GUROBI_HOME/lib```).

~~~
sbt assembly
~~~

Builds fat jars (jars with dependencies) in the bin subfolder.

### petrus-batch
The application used in:
A new approach to SG (2015) 

### petrus-bosansky2015
Implementation of the MILP described in bosansky2015

### petrus-chkconfig
This tool reads configuration files (for methods and games) and informs about syntax errors.

### petrus-gamegen
Random game generator. More details in the readme of the gamegen project.

### petus-graphviz
Converter of .json game files to visualization in the dot format (graphviz).

### petrus-gteval
Tool for generating MILP for solvers for a given game. (Only generates the lp file, the solver has to be run separately)

### petrus-gtopt
Most important project, it runs the given learning method on the given game and writes the strategy to stdout.

Methods:

- Mixed-UCT (most important)
- Uniform (generates uniform strategy)
- Milp (requieres solution file for MILP form solver, retrieves the strategy from it.)
  
### petrus-lib

Files common for all projects, like implementation of UCT and classes representing games. 

### petrus-mtg-compactlp

An extension of the LP described by Wang et al. for non zero-sum games with moving targets.

### petrus-profile

Project for testing computing performance. 

### petrus-solver

Provides a common interface for Gurobi and Scip solver.

### petrus-visualizer

Currently not working tool for visualizing a game.
