#!/usr/bin/env Rscript

require(jsonlite)

files <- commandArgs(trailingOnly = TRUE)

output <- files[1]
inputs <- files[-1]

## TODO obsługa powtórzeń eksperymentów

denormalize.payoff <- function(value) {
    (value-0.5)*60
}

file.to.record <- function(path) {
    game.name <- basename(gsub(pattern=".result", replacement = "", path))
    training.data <- read_json(path)

    data.frame(game = game.name, training.time = training.data$trainingTime,
               defenderPayoff = denormalize.payoff(training.data$payoff$defender),
               attackerPayoff = denormalize.payoff(training.data$payoff$attacker)
               )
}

generate.results.frame <- function(paths) {
    do.call(
        rbind,
        Map(file.to.record, paths)
    )
}

write.csv(
    generate.results.frame(inputs),
    output,
    row.names = FALSE
)
