#!/usr/bin/env Rscript

require(ggplot2)

args <- commandArgs(trailingOnly = TRUE)

pfdata <- read.csv(args[1], header = FALSE, col.names=c("it", "payoff", "ap"))

base.plot <- ggplot(pfdata, mapping = aes(x = it, y = payoff))

plot.variants <- function(pfdata, suffix="") {
    base.plot <- ggplot(pfdata, mapping = aes(x = it, y = payoff))
    ggsave(paste0(args[1], suffix, ".pdf"), base.plot+geom_line())
    ggsave(paste0(args[1], suffix, ".log.pdf"), base.plot+geom_line()+scale_y_log10())

    ggsave(paste0(args[1], suffix, ".point.pdf"), base.plot+geom_point())
    ggsave(paste0(args[1], suffix, ".point.log.pdf"), base.plot+geom_point()+scale_y_log10())
}

plot.variants(pfdata)
plot.variants(pfdata[pfdata$it >= 1000, ], ".k")
plot.variants(pfdata[pfdata$it < 1000, ], ".1k")
