#!/usr/bin/env Rscript

require(ggplot2)

args <- commandArgs(trailingOnly = TRUE)
#args <- c("../../../../matrix-results/out/mat-100-20-02-1.nfgame.momentum-short.1.out.i1.csv")

mdata <- data.frame(Map(as.numeric, read.csv(args[1], header=FALSE, col.names=paste0("s", 1:100))))

mm <- data.frame(i=1:nrow(mdata), m=rowMeans(abs(mdata), na.rm=TRUE))

generate.plots <- function(mm, infix) {
    ggsave(paste0(args[1], infix, ".momentum.plot.pdf"),
           ggplot(mm, mapping=aes(x=i, y=m))+geom_point()
           )

    ggsave(paste0(args[1], infix, ".momentum.logplot.pdf"),
           ggplot(mm, mapping=aes(x=i, y=m))+geom_point()+scale_y_log10()
           )
}

generate.plots(mm, "")
generate.plots(mm[1:1000, ], ".1k")
generate.plots(mm[-c(1:1000), ], ".k")
