#!/usr/bin/env Rscript

args <- commandArgs(trailingOnly = TRUE)

infile <- args[1]
outfile <- args[2]

old.data <- read.csv(args[1], header=TRUE)

new.data <- data.frame(
    method = old.data$config,
    game = gsub(".nfgame", "", old.data$game, fixed=TRUE),
    defender.payoff = old.data$uctDefenderPayoff.mean,
    attacker.payoff = old.data$uctAttackerPayoff.mean
    )


write.csv(new.data, outfile, row.names = FALSE)
