#!/usr/bin/env Rscript

args <- commandArgs(trailingOnly = TRUE)

infile <- args[1]
outfile <- args[2]

old.data <- read.csv(args[1], header=TRUE)

new.data <- data.frame(
    method = old.data$config,
    game = paste0(old.data$game, "-5"),
    defender.payoff = 0.5+(old.data$uctDefenderPayoff.mean/60),
    attacker.payoff = 0.5+(old.data$uctAttackerPayoff.mean/60)
    )


write.csv(new.data, outfile, row.names = FALSE)
