
get.best.results <- function(results.data.frames) {
    results <- do.call(rbind,results.data.frames)
    games.results <- split(results,results$game)
    do.call(rbind,Map(function(game.results) game.results[which.max(game.results$score),],games.results))
}


result.files <- commandArgs(trailingOnly = TRUE)

result.frames <- Map(function(file.name) read.csv(file.name,header=TRUE), result.files)

write.csv(get.best.results(result.frames),"best.results.csv",row.names=FALSE)
