stats <- list(min=min, max=max, mean=mean, sd=sd)

make.statistics <- function(results.file, out.file, game, config) {
    results <- read.csv(results.file, header=TRUE)
    results$uctTimeMs <- results$uctTimeMs/1000
    st <- do.call(data.frame, Map(function(column) Map(function(stat) do.call(stat,list(column)), stats), results))
    st <- round(st,4)
    st$game <- game
    st$config <- config
    write.csv(st, out.file, row.names=FALSE)
}

args <- commandArgs(trailingOnly = TRUE)

make.statistics(args[1], args[2], args[3], args[4])


