#!/usr/bin/env Rscript

mixeduct.file <- "/home/jan/research/security_games/experiments/runtime2a/sb-ijcai17.stat.csv"
milp.file <- "/home/jan/research/security_games/experiments/exact/exact.stat.csv"
bc.file <- "/home/jan/research/security_games/experiments-new/bosansky2015-out/mean.csv"

bc.file6 <- "/home/jan/research/security_games/experiments-new/sb-bosansky2015.tar/bosansky2015-out/mean6.csv"
mixeduct.file6 <- "/home/jan/research/security_games/experiments/gtopt12/smallbuilding6-full-ah500-rs-se.stat.csv"
uniform.file6 <- "/home/jan/research/security_games/experiments/sb6-random/sb6-random.stat.csv"


mixeduct.data <- read.csv(mixeduct.file, header = TRUE)
milp.data <- read.csv(milp.file, header = TRUE)
milp.data <- milp.data[milp.data$config=="milp", ]
bc.data <- read.csv(bc.file, header = TRUE)

mixeduct.data2 <- data.frame(mixeduct.mean = mixeduct.data$uctDefenderPayoff.mean,
                             mixeduct.max = mixeduct.data$uctDefenderPayoff.max,
                             mixeduct.sd = mixeduct.data$uctDefenderPayoff.sd,
                             mixeduct.time = mixeduct.data$uctTimeMs.mean,
                             game = paste0(mixeduct.data$game, "-5")
                             )

milp.data2 <- data.frame(
    milp.mean = milp.data$uctDefenderPayoff.mean,
    milp.time = milp.data$gtoptTime.mean,
    uniform = milp.data$randomAttackerPayoff.mean,
    game = paste0(milp.data$game, "-5")
)

bc.data2 <- data.frame(
    bc.mean = (bc.data$defender.payoff-0.5)*60,
    bc.time = bc.data$trainingTime,
    game = bc.data$game
)

all.data <- merge(merge(mixeduct.data2, milp.data2), bc.data2)

all.data$maxscore <- (all.data$mixeduct.max-all.data$uniform)/(all.data$bc.mean-all.data$uniform)
all.data <- rbind(all.data, Map(mean, all.data))

write.csv(all.data, "results.csv", row.names = FALSE)

rounded.data <- data.frame(
    game = all.data$game,
    mixeduct.mean = round(all.data$mixeduct.mean, 2),
    mixeduct.max = round(all.data$mixeduct.max, 2),
    mixeduct.sd = round(all.data$mixeduct.sd, 2),
    mixeduct.time = round(all.data$mixeduct.time),
    uniform = round(all.data$uniform, 2),
    bc.mean = round(all.data$bc.mean, 2),
    milp.time = round(all.data$milp.time),
    bc.time = round(all.data$bc.time),
    maxscore = round(all.data$maxscore, 2)
)

write.csv(rounded.data, "rounded.csv", row.names = FALSE)

bc.data6 <- read.csv(bc.file6, header=TRUE)
mixeduct.data6 <- read.csv(mixeduct.file6, header = TRUE);
mixeduct.data62 <- data.frame(mixeduct.mean = mixeduct.data6$uctDefenderPayoff.mean,
                              mixeduct.max = mixeduct.data6$uctDefenderPayoff.max,
                              mixeduct.sd = mixeduct.data6$uctDefenderPayoff.sd,
                             mixeduct.time = mixeduct.data6$uctTimeMs.mean,
                             game = paste0(mixeduct.data6$game, "-6")
                             )

uniform.data6 <-  read.csv(uniform.file6, header=TRUE)
uniform.data62 <- data.frame(uniform = uniform.data6$uctDefenderPayoff.mean,
                             game = paste0(uniform.data6$game, "-6")
                             )


bc.data62 <- data.frame(
    bc.mean = (bc.data6$defender.payoff-0.5)*60,
    bc.time = bc.data6$trainingTime,
    game = bc.data6$game
)

all.data <- merge(merge(mixeduct.data62, bc.data62), uniform.data62)

all.data$maxscore <- (all.data$mixeduct.max-all.data$uniform)/(all.data$bc.mean-all.data$uniform)
all.data <- rbind(all.data, Map(mean, all.data))
write.csv(all.data, "results6.csv", row.names = FALSE)


rounded.data <- data.frame(
    game = all.data$game,
    mixeduct.mean = round(all.data$mixeduct.mean, 2),
    mixeduct.max = round(all.data$mixeduct.max, 2),
    mixeduct.sd = round(all.data$mixeduct.sd, 2),
    mixeduct.time = round(all.data$mixeduct.time),
    uniform = round(all.data$uniform, 2),
    bc.mean = round(all.data$bc.mean, 2),
    bc.time = round(all.data$bc.time),
    maxscore = round(all.data$maxscore, 2)
)

write.csv(rounded.data, "rounded6.csv", row.names = FALSE)


##
