﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GeneticMultistepSG.Struct
{
    public class Ggame
    {
        public Graph graphConfig;

        public int rounds;

        public int defenderUnitCount;

        public List<int> targets;

        public int spawn;

        public List<double> vertexDefenderRewards;

        public List<double> vertexAttackerPenalties;

        public List<double> targetDefenderPenalties;

        public List<double> targetAttackerRewards;

        public string id;

        public List<List<int>> attackerStrategies;

        public List<List<int>> defenderStrategies;



        public void ComputeAttackerStrategies()
        {
            attackerStrategies = new List<List<int>>();
            ExtendAttackerStrategy(new List<int>() { spawn });
        }

        private void ExtendAttackerStrategy(List<int> currentStrategy)
        {
            int v = currentStrategy.Last(); //ostatni wierzchołek

            //doszliśmy do celu - koniec ścieżki atakującego, zapisujemy strategię
            if (targets.Contains(v) || currentStrategy.Count == rounds+1)
            {
                attackerStrategies.Add(currentStrategy.Select(x => x).ToList());
                return;
            }

            //nie doszliśmy do celu, ale koniec czasu - taka strategia jest zła dla atakującego, więc jej nie zapisujemy
            if (currentStrategy.Count > rounds)
                return;

            for (int i = 0; i < graphConfig.adjacencyList[v].Count; i++)
            {
                currentStrategy.Add(graphConfig.adjacencyList[v][i]);
                ExtendAttackerStrategy(currentStrategy);
                currentStrategy.RemoveAt(currentStrategy.Count - 1);
            }

        }



        public void ComputeDefenderStrategies()
        {
            defenderStrategies = new List<List<int>>();
            ExtendDefenderStrategy(new List<int>() { spawn });
        }

        private void ExtendDefenderStrategy(List<int> currentStrategy)
        {
            //minęła oczekiwana liczba rund - zapisujemy strategię
            if (currentStrategy.Count > rounds)
            {
                defenderStrategies.Add(currentStrategy.Select(x => x).ToList());
                return;
            }

            int v = currentStrategy.Last(); //ostatni wierzchołek

            for (int i = 0; i < graphConfig.adjacencyList[v].Count; i++)
            {
                currentStrategy.Add(graphConfig.adjacencyList[v][i]);
                ExtendDefenderStrategy(currentStrategy);
                currentStrategy.RemoveAt(currentStrategy.Count - 1);
            }

        }
    }
}
