﻿using GeneticMultistepSG.Struct;
using System.IO;
using System.Web.Script.Serialization;

namespace GeneticMultistepSG
{
	public static class ResultsExtractor
	{
		/// <summary>
		/// Łączy pliki csv z wynikiami do jednego pliku wynikowego
		/// </summary>
		public static void MergeResults(string dir, string output)
		{
			StreamWriter w = new StreamWriter(output);
			w.WriteLine("game;defenderPayoff;attackrPayoff;trainingTime;ierations;populationSize;mutationRate;crossoverRate;mutationRepeats;selectionPressure;isLocalOptimization;crossoverVersion");

			string[] files = Directory.GetFiles(dir);
			foreach (string file in files)
			{
				string[] lines = File.ReadAllLines(file);

				for (int i = 1; i < lines.Length; i++)
					w.WriteLine(lines[i]);
			}

			w.Close();
		}

		/// <summary>
		/// Z wskazanego folderu pobiera wszystkie pliki z rozszerzeniem .res, rozparsowuje je i zapisuje wyniki
		/// </summary>
		public static void ExtractResults(string directory, string targetFilePath)
		{
			StreamWriter w = new StreamWriter(targetFilePath);
			w.WriteLine("game;defenderPayoff;attackrPayoff;trainingTime");

			string[] files = Directory.GetFiles(directory, "*.res");
			foreach (string file in files)
			{
				Result gameResult = (new JavaScriptSerializer().Deserialize(File.ReadAllText(file), typeof(Result))) as Result;

				w.WriteLine(Path.GetFileNameWithoutExtension(file) + ";" + gameResult.payoff.defender + ";" + gameResult.payoff.attacker + ";" + gameResult.trainingTime);
			}
			w.Close();
		}

	}
}
