﻿using GeneticMultistepSG.Struct;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web.Script.Serialization;

namespace GeneticMultistepSG
{
	public class Program
	{
		public static Random rand = new Random();

		public static Ggame gameDefinition;

        public static Config config;

		public static int iterations = 1000;

		public static double EPS = 0.00001;

        public static Population population;

        static void Main(string[] args)
        {
            string gamesFile = args[1];
            string resultFile = args[2];

            List<Config> configs = generateConfigs();

            List<string> games = new List<string>();
            games.AddRange(File.ReadAllLines(gamesFile));

            StreamWriter w = new StreamWriter(resultFile);

            config = configs[0];
            for (int i = 0; i < 30; i++)
            {
                string game = games[rand.Next(games.Count)];

                if (!File.Exists(game)) continue;

                population = new Population();

                gameDefinition = LoadGameDefinition(game);

                DateTime startTime = DateTime.Now;
                population.InitPopulation();

                double previousFittingFunction = double.MinValue;
                int lastIterationFittingFunctionChange = -1;

                int it = 0;
                for (it = 0; it < iterations; it++)
                {
                    Console.WriteLine("it: " + it);
                    population.MakeNewPopulation();
                    Console.WriteLine(string.Format("Iteration {0}. Attack on target {1}. Attacker payoff: {2}. Defender payoff: {3}",
                        it, population.chromosomes[0].attackStrategy.Last(), population.chromosomes[0].attackerResult, population.chromosomes[0].fittingFunction));

                    if (Math.Abs(population.chromosomes[0].fittingFunction - previousFittingFunction) > EPS)
                    {
                        previousFittingFunction = population.chromosomes[0].fittingFunction;
                        lastIterationFittingFunctionChange = it;
                    }

                    if (it - lastIterationFittingFunctionChange > 100)
                    {
                        double fittingFunction;
                        double attackerResult;
                        population.chromosomes[0].CalculatePayoff(population.chromosomes[0].attackStrategy, new List<BoundedRationalityStrategy>() { BoundedRationalityStrategy.AnchoringTheoryProbability }, out attackerResult, out fittingFunction);
                        w.WriteLine(game + ";" + "no-AT" + ";" + population.chromosomes[0].fittingFunction + ";" + fittingFunction + ";" + population.chromosomes[0].attackerResult + ";" + attackerResult);
                        w.Flush();
                        break;
                    }
                }

                int trainingTime = (int)DateTime.Now.Subtract(startTime).TotalSeconds;

            }

            w.Close();
        }


		static Ggame LoadGameDefinition(string filePath)
		{
			Ggame gameDefinition = (new JavaScriptSerializer().Deserialize(File.ReadAllText(filePath), typeof(Ggame))) as Ggame;
			gameDefinition.graphConfig.MakeAdjacencyList();
			gameDefinition.ComputeAttackerStrategies();
            gameDefinition.ComputeDefenderStrategies();
			return gameDefinition;
		}

        static List<Config> generateConfigs()
        {
            Config c0 = new Config();
            c0.configName = "baseline";

            Config c1 = new Config();
            c1.goodInitialStrategies = true;
            c1.configName = "goodInitialStrategies";

            Config c2 = new Config();
            c2.newIndividualsInGeneration = true;
            c2.configName = "newIndividualsInGeneration";

            Config c3 = new Config();
            c3.mutationAddPureStrategy = true;
            c3.configName = "mutationAddPureStrategy";

            Config c4 = new Config();
            c4.mutationDeletePureStrategy = true;
            c4.configName = "mutationDeletePureStrategy";

            Config c5 = new Config();
            c5.mutationChangeProbability = true;
            c5.configName = "mutationChangeProbability";

            Config c6 = new Config();
            c6.mutationSwitchProbability = true;
            c6.configName = "mutationSwitchProbability";

            Config c7 = new Config();
            c7.mutationWeakestPureStrategy = true;
            c7.configName = "mutationWeakestPureStrategy";

            Config c8 = new Config();
            c8.mutationWeakestPureStrategyProportional = true;
            c8.configName = "mutationWeakestPureStrategyProportional";

            Config c9 = new Config();
            c9.crossoverWithPayoff = true;
            c9.configName = "crossoverWithPayoff";
            
            Config c10 = new Config();
            c10.mutationAddPureStrategy = true;
            c10.mutationBetterPayoff = true;
            c10.configName = "betterPayoff_mutationAddPureStrategy";

            Config c11 = new Config();
            c11.mutationDeletePureStrategy = true;
            c11.mutationBetterPayoff = true;
            c11.configName = "betterPayoff_mutationDeletePureStrategy";

            Config c12 = new Config();
            c12.mutationChangeProbability = true;
            c12.mutationBetterPayoff = true;
            c12.configName = "betterPayoff_mutationChangeProbability";

            Config c13 = new Config();
            c13.mutationSwitchProbability = true;
            c13.mutationBetterPayoff = true;
            c13.configName = "betterPayoff_mutationSwitchProbability";

            Config c15 = new Config();
            c15.mutationDeletePureStrategy = true;
            c15.mutationWeakestPureStrategy = true;
            c15.configName = "weakest_mutationDeletePureStrategy";

            Config c16 = new Config();
            c16.mutationDeletePureStrategy = true;
            c16.mutationWeakestPureStrategyProportional = true;
            c16.configName = "weakestProportional_mutationDeletePureStrategy";
            
            List<Config> configs = new List<Config> { c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c15, c16 };
            return configs;
        }

	}
}
