﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GeneticMultistepSG.Struct
{
    /// <summary> Wierzchołek w drzewie strategii reprezentujący pewien stan gry
    /// </summary>
    public class NodeStrategy
    {
        public NodeStrategy()
        {
            children = new List<NodeStrategy>();
            probabilities = new List<double>();
        }

        /// <summary> Pozycja obrońcy w danym stanie
        /// </summary>
        public int position;

        /// <summary> Krok czasowy (odległość od korzenia w drzewie)
        /// </summary>
        public int interval;

        /// <summary> Lista następników
        /// </summary>
        public List<NodeStrategy> children;

        /// <summary> Rodzic węzła
        /// </summary>
        public NodeStrategy parent;

        /// <summary> Lista prawdopodobieństw wyboru poszczególnych następników (i-ty element to pstwo wyboru children[i])
        /// </summary>
        public List<double> probabilities;

        public NodeStrategy Copy(NodeStrategy parentCopy)
        {
            NodeStrategy result = new NodeStrategy();
            result.position = position;
            result.interval = interval;
            result.children = children.Select(x => x.Copy(result)).ToList();
            result.probabilities = probabilities.Select(x => x).ToList();
            result.parent = parentCopy;
            return result;
        }

        public string MakeDescription()
        {
            string result = "";
            result += "interval: " + interval + " position: " + position + "\n";
            for (int i=0; i<children.Count; i++)
            {
                result += "prob: " + probabilities[i] + " " + children[i].MakeDescription();
            }

            return result;
        }

        public void Normalize()
        {
            double probabilitiesSum = probabilities.Sum();
            probabilities = probabilities.Select(x => x / probabilitiesSum).ToList();

            foreach (NodeStrategy n in children)
                n.Normalize();
        }
    }
}
