﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GeneticMultistepSG.Struct
{
    /// <summary>
    /// Strategia mieszana obrońcy
    /// </summary>
    public class DefenderStrategy
    {
        /// <summary> Lista pozycji (wierzchołków) w poszczególnych interwałach czasowych elements[i][j] - pozycja w i-tej strategii w j-tym interwale czasowym
        /// </summary>
        public List<int[]> elements;

        /// <summary> Prawdopodobieństwa wyboru poszczególnych strategii
        /// </summary>
        public List<double> probabilities;

        /// <summary> wypłata poszczególnych strategii prostych przeciwko najlepszemu atakującemu (najlepszemu dla całej strategii mieszanej)
        /// </summary>
        public List<double> partialPayoffs;

        public DefenderStrategy()
        {
            elements = new List<int[]>();
            probabilities = new List<double>();
            partialPayoffs = new List<double>();
        }

        /// <summary>
        /// Tworzy kopię obiektu, parametr toRemove to lista indeksów, które trzeba usunąć podczas tworzenia kopii
        /// </summary>
        public DefenderStrategy Copy(List<int> toRemove = null)
        {
            DefenderStrategy result = new DefenderStrategy();
            for (int i = 0; i < elements.Count; i++)
            {
                if (toRemove != null && toRemove.Contains(i))
                    continue;
                result.elements.Add(new int[elements[i].Length]);
                for (int j = 0; j < elements[i].Length; j++)
                    result.elements.Last()[j] = elements[i][j];

                result.probabilities.Add(probabilities[i]);
                result.partialPayoffs.Add(partialPayoffs[i]);
            }

            result.NormalizeProbabilities();

            return result;
        }

        public void NormalizeProbabilities()
        {
            double probabilitiesSum = probabilities.Sum();
            probabilities = probabilities.Select(x => x * (1 / probabilitiesSum)).ToList();
        }
    }
}
