﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GeneticMultistepSG.Struct
{
    public enum BoundedRationalityStrategy
    {
        ProspectTheoryPayoff,
        ProspectTheoryProbability,
        AnchoringTheoryProbability,
        AnchoringTheoryProbabilityApproximation
    }

    public class BoundedRationality
    {
        public static double ProspectTheoryPayoff(double payoff)
        {
            double alpha = 0.88, beta = 0.88, omega = 2.25;

            if (payoff > 0)
                return Math.Pow(payoff, alpha);
            else
                return -omega * Math.Pow(-payoff, beta);
        }


        public static DefenderStrategy AnchoringTheoryProbabilityApproximation(DefenderStrategy defStrategy)
        {
            double alpha = 0.5;
            DefenderStrategy result = defStrategy.Copy();

            foreach (List<int> s in Program.gameDefinition.defenderStrategies)
            {
                result.elements.Add(s.ToArray());
                result.probabilities.Add(alpha / Program.gameDefinition.defenderStrategies.Count);
            }

            //normalizacja prawdopodobienstw
            double probabilitiesSum = result.probabilities.Sum();
            result.probabilities = result.probabilities.Select(x => x * (1 / probabilitiesSum)).ToList();

            return result;
        }


        public static DefenderStrategy AnchoringTheoryProbability(DefenderStrategy defStrategy)
        {
            double alpha = 0.5;
            DefenderStrategy result = defStrategy.Copy();

            for (int i = 0; i < result.probabilities.Count; i++)
                result.probabilities[i] = (1.0 - alpha) * result.probabilities[i];

            foreach (List<int> s in Program.gameDefinition.defenderStrategies)
            {
                    result.elements.Add(s.ToArray());
                    result.probabilities.Add(alpha / Program.gameDefinition.defenderStrategies.Count);
            }

            //normalizacja prawdopodobienstw
            double probabilitiesSum = result.probabilities.Sum();
            result.probabilities = result.probabilities.Select(x => x * (1 / probabilitiesSum)).ToList();

            return result;
        }

    }
}
