﻿using GeneticMultistepCoevoSG;
using GeneticMultistepCoevoSG.Struct;
using GeneticMultistepSG.Struct;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Script.Serialization;

namespace GeneticMultistepSG
{
    public class Program
    {
        public static Random rand = new Random(7);

        public static Game gameDefinition;

        public static int iterations = 100;

        public static int iterationsDefender = 50;

        public static int iterationsAttacker = 50;

        public static double EPS = 0.00001;

        public static PopulationAttacker populationAttacker;

        public static PopulationDefender populationDefender;

        public static StreamWriter attackerWriter;

        public static string currentGame;

        public static int currentIt;

        static void Main(string[] args)
        {
            MainFlipItGame(args);
        }

        static void MainFlipItGame(string[] args)
        {
            attackerWriter = new StreamWriter(@"path-to-file\resultsAttacker" + DateTime.Now.ToString("yyyy-MM-dd_HH-mm-ss-FFF") + ".csv");
            StreamWriter writer = new StreamWriter(@"path-to-file\results" + DateTime.Now.ToString("yyyy-MM-dd_HH-mm-ss-FFF") + ".csv");
            StreamWriter writerDetailed = new StreamWriter(@"path-to-file\resultsDetailed" + DateTime.Now.ToString("yyyy-MM-dd_HH-mm-ss-FFF") + ".csv");

            writerDetailed.WriteLine("game;populationSize;itAll;iterationInner;whoseIteration;defenderPayoff;attackerPayoff;defenderPayoffOptimal;attackerPayoffOptimal");
            writer.WriteLine("game;iterations;iterationsDefender;iterationsAttacker;populationDefenderSize;populationAttackerSize;evaluationVersionAttacker;defenderPayoff;attackerPayoff;defenderPayoffOptimal;attackerPayoffOptimal;itAll;howManyTheSamePairs;howManyTheSameMax;howManyDistinct;defenderChangeIt;attackerChangeIt;lastIterationFittingFunctionChange");

            string[] games = Directory.GetFiles(@"path-to-file\games", "*.niflip").Select(x => Path.GetFileName(x)).ToArray();


            List<int> populationSizeAttackerList = new List<int>() { 10, 20, 50, 100, 200 };
            List<int> iterationsAttackerList = new List<int>() { 2, 5, 10, 20, 50, 100 };
            List<int> iterationsDefenderList = new List<int>() { 2, 5, 10, 20, 50, 100 };
            List<int> iterationsList = new List<int>() { 10, 20, 50, 100, 200, 500 };
            List<int> evaluationVersionAttackerList = new List<int>() { 0, 1 };


            //while (true)
            for (int j = 0; j < games.Length; j++)
            //foreach (int popSize in populationSize)
            {
                string game = games[j];
                currentGame = game;
                string filePath = @"path-to-file\games\" + game;
                if (!File.Exists(filePath)) continue;

                populationDefender = new PopulationDefenderFlipItGame();
                populationAttacker = new PopulationAttackerFlipItGame();
                populationAttacker.populationSize = 50; // populationSizeAttackerList[Program.rand.Next(populationSizeAttackerList.Count)];
                populationAttacker.evaluationVersion = 1; // evaluationVersionAttackerList[Program.rand.Next(evaluationVersionAttackerList.Count)];

                iterationsAttacker = 20; // iterationsAttackerList[Program.rand.Next(iterationsAttackerList.Count)];
                iterationsDefender = 20; // iterationsDefenderList[Program.rand.Next(iterationsDefenderList.Count)];
                iterations = 50; // iterationsList[Program.rand.Next(iterationsList.Count)];

                gameDefinition = LoadFlipItGameDefinition(filePath);

                DateTime startTime = DateTime.Now;
                populationDefender.InitPopulation();
                populationAttacker.InitPopulation();

                double previousFittingFunction = double.MinValue;
                int lastIterationFittingFunctionChange = -1;

                int sumDefenderChange = 0;
                int sumAttackerChange = 0;
                int sumIt = 0;

                int it = 0;

                int allIt = 0;
                for (it = 0; it < iterations; it++)
                {
                    currentIt = it;
                    int itDefender = 0;
                    int lastChange = 0;
                    double previousPayoff = double.MaxValue;
                    for (itDefender = 0; itDefender < iterationsDefender; itDefender++)
                    {
                        allIt++;
                        populationDefender.MakeNewPopulation();
                        populationDefender.chromosomes[0].EvaluateOptimal();
                        writerDetailed.WriteLine(game + ";" + populationAttacker.populationSize + ";" + allIt + ";" + itDefender + ";Defender;" + populationDefender.chromosomes[0].fittingFunction + ";" + populationDefender.chromosomes[0].attackerResult
                                + ";" + populationDefender.chromosomes[0].fittingFunctionOptimal + ";" + populationDefender.chromosomes[0].attackerResultOptimal
                                + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategy));// + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategyOptimal));

                        if (Math.Abs(previousPayoff - populationDefender.chromosomes[0].fittingFunction) > EPS)
                            lastChange = itDefender;
                        previousPayoff = populationDefender.chromosomes[0].fittingFunction;
                    }

                    if (lastIterationFittingFunctionChange == it - 1)
                        sumDefenderChange += lastChange;


                    previousPayoff = double.MaxValue;
                    int itAttacker = 0;
                    lastChange = 0;
                    for (itAttacker = 0; itAttacker < iterationsAttacker; itAttacker++)
                    {
                        allIt++;
                        populationAttacker.MakeNewPopulation();
                        populationDefender.chromosomes[0].EvaluateAttackerPopulation();
                        populationDefender.chromosomes[0].EvaluateOptimal();

                        writerDetailed.WriteLine(game + ";" + populationAttacker.populationSize + ";" + allIt + ";" + itAttacker + ";Attacker;" + populationDefender.chromosomes[0].fittingFunction + ";" + populationDefender.chromosomes[0].attackerResult
                            + ";" + populationDefender.chromosomes[0].fittingFunctionOptimal + ";" + populationDefender.chromosomes[0].attackerResultOptimal
                            + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategy));// + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategyOptimal));

                        if (Math.Abs(previousPayoff - populationDefender.chromosomes[0].fittingFunction) > EPS)
                            lastChange = itAttacker;
                        previousPayoff = populationDefender.chromosomes[0].fittingFunction;
                    }

                    if (lastIterationFittingFunctionChange == it - 1)
                    {
                        sumIt++;
                        sumAttackerChange += lastChange;
                    }

                    writer.Flush();

                    populationDefender.chromosomes[0].EvaluateOptimal();

                    Console.WriteLine(populationAttacker.chromosomes.Count(x => x.isBest));
                    Console.WriteLine(populationAttacker.chromosomes.FindIndex(x => x.isBest));

                    //List<ChromosomeAttacker> isBestList = populationAttacker.chromosomes.Where(x => x.isBest).ToList();

                    if (!populationAttacker.chromosomes.Any(x => x.isBest && string.Join(",", x.strategy) == string.Join(",", populationAttacker.chromosomes[0].strategy)))
                        populationAttacker.chromosomes[0].isBest = true;


                    if (Math.Abs(populationDefender.chromosomes[0].fittingFunction - previousFittingFunction) > EPS)
                    {
                        previousFittingFunction = populationDefender.chromosomes[0].fittingFunction;
                        lastIterationFittingFunctionChange = it;
                    }

                    if (it - lastIterationFittingFunctionChange > 100)
                        break;
                }

                int trainingTime = (int)DateTime.Now.Subtract(startTime).TotalSeconds;

                writer.WriteLine(game + ";" + populationDefender.chromosomes[0].fittingFunction + ";" + populationDefender.chromosomes[0].attackerResult + ";" + trainingTime + ";" + it);
                //writer.WriteLine(game + ";" + iterations + ";" + iterationsDefender + ";" + iterationsAttacker + ";" + populationDefender.populationSize + ";" + populationAttacker.populationSize + ";" + populationAttacker.evaluationVersion + ";"
                //    + populationDefender.chromosomes[0].fittingFunction + ";" + populationDefender.chromosomes[0].attackerResult + ";" + populationDefender.chromosomes[0].fittingFunctionOptimal + ";"
                //    + populationDefender.chromosomes[0].attackerResultOptimal + ";" + allIt + ";" + (double)PopulationAttackerGGame.howManyDistinct / allIt + ";" + (double)sumDefenderChange / sumIt + ";" + (double)sumAttackerChange / sumIt + ";" + lastIterationFittingFunctionChange);
                writer.Flush();

                //Console.WriteLine("Strategies not considered: ");
                //for (int j = 0; j < Program.gameDefinition.attackerStrategiesConsidered.Count; j++)
                //    if (!Program.gameDefinition.attackerStrategiesConsidered[j])
                //        Console.WriteLine(string.Join(",", Program.gameDefinition.attackerStrategies[j]));
            }
            writer.Close();
            writerDetailed.Close();
            attackerWriter.Close();
        }

        static void MainGGame(string[] args)
        {
            attackerWriter = new StreamWriter(@"path-to-file\resultsAttacker" + DateTime.Now.ToString("yyyy-MM-dd_HH-mm-ss-FFF") + ".csv");
            StreamWriter writer = new StreamWriter(@"path-to-file\results" + DateTime.Now.ToString("yyyy-MM-dd_HH-mm-ss-FFF") + ".csv");
            StreamWriter writerDetailed = new StreamWriter(@"path-to-file\resultsDetailed" + DateTime.Now.ToString("yyyy-MM-dd_HH-mm-ss-FFF") + ".csv");

            writerDetailed.WriteLine("game;populationSize;itAll;iterationInner;whoseIteration;defenderPayoff;attackerPayoff;defenderPayoffOptimal;attackerPayoffOptimal");
            writer.WriteLine("game;iterations;iterationsDefender;iterationsAttacker;populationDefenderSize;populationAttackerSize;evaluationVersionAttacker;defenderPayoff;attackerPayoff;defenderPayoffOptimal;attackerPayoffOptimal;itAll;howManyTheSamePairs;howManyTheSameMax;howManyDistinct;defenderChangeIt;attackerChangeIt;lastIterationFittingFunctionChange");
            string[] games = new string[] { "smallbuilding-17-5"/*, "smallbuilding-2-5",
				"smallbuilding-20-5", "smallbuilding-24-5", "smallbuilding-3-5", "smallbuilding-31-5",
				"smallbuilding-35-5", "smallbuilding-39-5", "smallbuilding-41-5", "smallbuilding-42-5",
				"smallbuilding-43-5", "smallbuilding-56-5", "smallbuilding-59-5", "smallbuilding-64-5",
				"smallbuilding-7-5", "smallbuilding-74-5", "smallbuilding-78-5", "smallbuilding-82-5",
				"smallbuilding-85-5", "smallbuilding-87-5", "smallbuilding-89-5", "smallbuilding-91-5",
				"smallbuilding-96-5", "smallbuilding-98-5"*/};

            games = File.ReadAllLines(@"path-to-file\smallbuilding-nontrivial.set");


            List<int> populationSizeAttackerList = new List<int>() { 10, 20, 50, 100, 200 };
            List<int> iterationsAttackerList = new List<int>() { 2, 5, 10, 20, 50, 100 };
            List<int> iterationsDefenderList = new List<int>() { 2, 5, 10, 20, 50, 100 };
            List<int> iterationsList = new List<int>() { 10, 20, 50, 100, 200, 500 };
            List<int> evaluationVersionAttackerList = new List<int>() { 0, 1 };


            while (true)
                for (int j = 0; j < games.Length; j++)
                //foreach (int popSize in populationSize)
                {
                    string game = games[j];
                    currentGame = game;
                    string filePath = @"path-to-file\" + game;
                    if (!File.Exists(filePath)) continue;

                    populationDefender = new PopulationDefenderGGame();
                    populationAttacker = new PopulationAttackerGGame();
                    populationAttacker.populationSize = 50; // populationSizeAttackerList[Program.rand.Next(populationSizeAttackerList.Count)];
                    populationAttacker.evaluationVersion = 1; // evaluationVersionAttackerList[Program.rand.Next(evaluationVersionAttackerList.Count)];

                    iterationsAttacker = 10; // iterationsAttackerList[Program.rand.Next(iterationsAttackerList.Count)];
                    iterationsDefender = 10; // iterationsDefenderList[Program.rand.Next(iterationsDefenderList.Count)];
                    iterations = 100; // iterationsList[Program.rand.Next(iterationsList.Count)];

                    gameDefinition = LoadGGameDefinition(filePath);

                    DateTime startTime = DateTime.Now;
                    populationDefender.InitPopulation();
                    populationAttacker.InitPopulation();

                    double previousFittingFunction = double.MinValue;
                    int lastIterationFittingFunctionChange = -1;

                    int sumDefenderChange = 0;
                    int sumAttackerChange = 0;
                    int sumIt = 0;

                    int it = 0;

                    int allIt = 0;
                    for (it = 0; it < iterations; it++)
                    {
                        currentIt = it;
                        int itDefender = 0;
                        int lastChange = 0;
                        double previousPayoff = double.MaxValue;
                        for (itDefender = 0; itDefender < iterationsDefender; itDefender++)
                        {
                            allIt++;
                            populationDefender.MakeNewPopulation();
                            writerDetailed.WriteLine(game + ";" + populationAttacker.populationSize + ";" + allIt + ";" + itDefender + ";Defender;" + populationDefender.chromosomes[0].fittingFunction + ";" + populationDefender.chromosomes[0].attackerResult
                                + ";" + populationDefender.chromosomes[0].fittingFunctionOptimal + ";" + populationDefender.chromosomes[0].attackerResultOptimal
                                + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategy));// + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategyOptimal));

                            if (Math.Abs(previousPayoff - populationDefender.chromosomes[0].fittingFunction) > EPS)
                                lastChange = itDefender;
                            previousPayoff = populationDefender.chromosomes[0].fittingFunction;
                        }

                        if (lastIterationFittingFunctionChange == it - 1)
                            sumDefenderChange += lastChange;

                        previousPayoff = double.MaxValue;
                        int itAttacker = 0;
                        lastChange = 0;
                        for (itAttacker = 0; itAttacker < iterationsAttacker; itAttacker++)
                        {
                            allIt++;
                            populationAttacker.MakeNewPopulation();
                            populationDefender.chromosomes[0].EvaluateAttackerPopulation();


                            writerDetailed.WriteLine(game + ";" + populationAttacker.populationSize + ";" + allIt + ";" + itAttacker + ";Attacker;" + populationDefender.chromosomes[0].fittingFunction + ";" + populationDefender.chromosomes[0].attackerResult
                                + ";" + populationDefender.chromosomes[0].fittingFunctionOptimal + ";" + populationDefender.chromosomes[0].attackerResultOptimal
                                + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategy));// + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategyOptimal));

                            if (Math.Abs(previousPayoff - populationDefender.chromosomes[0].fittingFunction) > EPS)
                                lastChange = itAttacker;
                            previousPayoff = populationDefender.chromosomes[0].fittingFunction;
                        }

                        if (lastIterationFittingFunctionChange == it - 1)
                        {
                            sumIt++;
                            sumAttackerChange += lastChange;
                        }

                        writer.Flush();

                        populationDefender.chromosomes[0].EvaluateOptimal();

                        Console.WriteLine("AfterAttacker iteracja " + it + " aktualny wynik: (" + populationDefender.chromosomes[0].fittingFunction + " " + populationDefender.chromosomes[0].attackerResult + ")"
                            + " optymalny wynik: (" + populationDefender.chromosomes[0].fittingFunctionOptimal + " " + populationDefender.chromosomes[0].attackerResultOptimal + ")"
                            + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategy));// + ";" + String.Join(",", populationDefender.chromosomes[0].attackStrategyOptimal));

                        Console.WriteLine(populationAttacker.chromosomes.Count(x => x.isBest));
                        Console.WriteLine(populationAttacker.chromosomes.FindIndex(x => x.isBest));

                        //List<ChromosomeAttacker> isBestList = populationAttacker.chromosomes.Where(x => x.isBest).ToList();

                        if (!populationAttacker.chromosomes.Any(x => x.isBest && string.Join(",", x.strategy) == string.Join(",", populationAttacker.chromosomes[0].strategy)))
                            populationAttacker.chromosomes[0].isBest = true;


                        if (Math.Abs(populationDefender.chromosomes[0].fittingFunction - previousFittingFunction) > EPS)
                        {
                            previousFittingFunction = populationDefender.chromosomes[0].fittingFunction;
                            lastIterationFittingFunctionChange = it;
                        }

                        if (it - lastIterationFittingFunctionChange > 100)
                            break;
                    }

                    int trainingTime = (int)DateTime.Now.Subtract(startTime).TotalSeconds;

                    //Console.WriteLine(game + ";" + population.chromosomes[0].fittingFunction + ";" + population.chromosomes[0].attackerResult + ";" + trainingTime + ";" + it);
                    writer.WriteLine(game + ";" + iterations + ";" + iterationsDefender + ";" + iterationsAttacker + ";" + populationDefender.populationSize + ";" + populationAttacker.populationSize + ";" + populationAttacker.evaluationVersion + ";"
                        + populationDefender.chromosomes[0].fittingFunction + ";" + populationDefender.chromosomes[0].attackerResult + ";" + populationDefender.chromosomes[0].fittingFunctionOptimal + ";"
                        + populationDefender.chromosomes[0].attackerResultOptimal + ";" + allIt + ";" + (double)PopulationAttackerGGame.howManyTheSamePairs / allIt + ";" + (double)PopulationAttackerGGame.howManyTheSameMax / allIt + ";" + (double)PopulationAttackerGGame.howManyDistinct / allIt + ";" + (double)sumDefenderChange / sumIt + ";" + (double)sumAttackerChange / sumIt + ";" + lastIterationFittingFunctionChange);
                    writer.Flush();

                    //Console.WriteLine("Strategies not considered: ");
                    //for (int j = 0; j < Program.gameDefinition.attackerStrategiesConsidered.Count; j++)
                    //    if (!Program.gameDefinition.attackerStrategiesConsidered[j])
                    //        Console.WriteLine(string.Join(",", Program.gameDefinition.attackerStrategies[j]));
                }
            writer.Close();
            writerDetailed.Close();
            attackerWriter.Close();
        }

        static Ggame LoadGGameDefinition(string filePath)
        {
            Ggame gameDefinition = (new JavaScriptSerializer().Deserialize(File.ReadAllText(filePath), typeof(Ggame))) as Ggame;
            gameDefinition.graphConfig.MakeAdjacencyList();
            gameDefinition.ComputeAttackerStrategies();
            return gameDefinition;
        }


        static FlipItGame LoadFlipItGameDefinition(string filePath)
        {
            FlipItGame gameDefinition = (new JavaScriptSerializer().Deserialize(File.ReadAllText(filePath), typeof(FlipItGame))) as FlipItGame;
            gameDefinition.graph.MakeAdjacencyList();
            gameDefinition.ComputeAttackerStrategies();

            int count = gameDefinition.attackerStrategies.Count(x => x.Last() == 1);

            return gameDefinition;
        }


    }
}
